/*
 * Copyright 2018-2019 NXP
 * All rights reserved.
 *
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "fsl_common.h"
#include "power_mode_switch_bm.h"
#include "board.h"
#include "fsl_debug_console.h"
#include "lpm.h"
#include "fsl_gpt.h"
#include "fsl_lpuart.h"
#include "specific.h"
#include "fsl_state_machine.h"
#include "fsl_xbara.h"
#include "fsl_iomuxc.h"

#include "pin_mux.h"
#include "clock_config.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define CPU_NAME "iMXRT1011"

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/* Clock pre divider for flexio clock source */
#define MASTER_FLEXIO_SSI_CLOCK_PRE_DIVIDER (4U)
/* Clock divider for flexio clock source */
#define MASTER_FLEXIO_SSI_CLOCK_DIVIDER (7U)
#define MASTER_FLEXIO_SSI_CLOCK_FREQUENCY                                            \
    (CLOCK_GetFreq(kCLOCK_Usb1PllClk) / (MASTER_FLEXIO_SSI_CLOCK_PRE_DIVIDER + 1U) / \
     (MASTER_FLEXIO_SSI_CLOCK_DIVIDER + 1U))
      
      
FLEXIO_STATEMACHINE_Type stateDev;
flexio_statemachine_config_t stateconfig;
/*******************************************************************************
 * Code
 ******************************************************************************/
/*
 * PLL4 setting: Frequency = Fref * (DIV_SELECT + NUM / DENOM)/postDivider
 *                              = 24 * (32 + 77/100)/4
 *                              = 786.48 MHz/4
                                = 192.62MHz
 */
const clock_audio_pll_config_t audioPllConfig = {
    .loopDivider = 32,  /* PLL loop divider. Valid range for DIV_SELECT divider value: 27~54. */
    .postDivider = 4,   /* Divider after the PLL, should only be 1, 2, 4, 8, 16. */
    .numerator   = 77,  /* 30 bit numerator of fractional loop divider. */
    .denominator = 100, /* 30 bit denominator of fractional loop divider */
};

uint32_t freq;
/*!
 * @brief main demo function.
 */
int main(void)
{
  
    /* Init board hardware. */
    BOARD_ConfigMPU();
    BOARD_InitPins();
    BOARD_BootClockRUN();
    CLOCK_InitAudioPll(&audioPllConfig);
    /* Clock setting for Flexio */
    CLOCK_SetMux(kCLOCK_Flexio1Mux, 0);//derive clock from PLL4   
    CLOCK_SetDiv(kCLOCK_Flexio1PreDiv, MASTER_FLEXIO_SSI_CLOCK_PRE_DIVIDER);
    CLOCK_SetDiv(kCLOCK_Flexio1Div, MASTER_FLEXIO_SSI_CLOCK_DIVIDER); //192.62MHz/40=4.8155  timer = 4.8155MHz/6000/2 =401Hz
    
//    IOMUXC_SetPinMux(
//      IOMUXC_GPIO_SD_02_CCM_CLKO1,            /* GPIO_SD_02 is configured as CCM_CLKO1 */
//      0U);                                    /* Software Input On Field: Input Path is determined by functionality */

    /* Clock setting for Flexio */
    CLOCK_EnableClock(kCLOCK_Flexio1);

    /*FlexIO low power state machine initialization */
    stateDev.flexioBase         = FLEXIO1;
    stateDev.InputPinIndex      = 21;
    stateDev.shifterIndex[0]    = 0;
    stateDev.shifterIndex[1]    = 1;
    stateDev.shifterIndex[2]    = 2;
    stateDev.timerIndex[0]      = 0U;
    
    FLEXIO_StateMachine_InitGetDefaultConfig(&stateconfig);
    FLEXIO_StateMachine_Init(&stateDev, &stateconfig);
   
    LPM_Init();
  
    LPM_PreEnterWaitMode();
    LPM_EnterLowPowerIdle();

    while (1)
    {
    }
}
